Imports System.IO.Ports
Imports System.Text
Imports System.Threading
Public Class NETSerialTerm
    Public Shared WithEvents SerialPort As SerialPort
    Private Shared m_FormDefInstance As NETSerialTerm
    Private Shared m_InitializingDefInstance As Boolean
    Private Shared SerialPortClosing As Boolean
    Private Shared ReceiveBuffer As String = ""
    Private Shared Data2Display As New StringBuilder(4096)
    Private Shared DispData As New DispClass

    'the following are used to intrument throughput measurements
    Private TimeAtStart As Long
    Private TotalBytes As Long
    Private Throughput As Single

    'the following is for a special instrument Coulter AcT Series Analyzer
    Private Parser As New ParseASTM1394
    Dim WithEvents Framer As New ParseASTM1381

    Public Shared Property DefInstance() As NETSerialTerm
        Get
            If m_FormDefInstance Is Nothing OrElse _
                        m_FormDefInstance.IsDisposed Then
                m_InitializingDefInstance = True
                m_FormDefInstance = New NETSerialTerm
                m_InitializingDefInstance = False
            End If
            DefInstance = m_FormDefInstance
        End Get
        Set(ByVal Value As NETSerialTerm)
            m_FormDefInstance = Value
        End Set
    End Property

    Private Sub PortOpenToolStripMenuItem_Click(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles PortOpenToolStripMenuItem.Click
        Dim ex As Exception
        With SerialPort
            If .IsOpen = False Then
                Try
                    .Open()
                Catch ex
                End Try
            Else
                Try
                    SerialPortClosing = True
                    .Close()
                Catch ex
                End Try
            End If
            If .IsOpen = True Then
                PortOpenToolStripMenuItem.Checked = True
                Me.Text = "NETSerialTerm using port: " & _
                                    SerialPort.PortName
                .ReceivedBytesThreshold = 1
                SerialPortClosing = False
                Throughput = 0
                TimeAtStart = 0
                TotalBytes = 0
                Button1.Enabled = True
            Else
                PortOpenToolStripMenuItem.Checked = False
                Me.Text = "NETSerialTerm not running"
                SerialPortClosing = True
            End If
        End With
    End Sub

    Private Sub txtTerm_KeyPress(ByVal sender As Object, ByVal e As _
    System.Windows.Forms.KeyPressEventArgs) Handles txtTerm.KeyPress
        Dim KeyAscii As Int32 = Asc(e.KeyChar)
        With SerialPort
            If .IsOpen = True Then
                .Write(Chr(KeyAscii))
            End If
        End With
        e.Handled = True
    End Sub

    Private Delegate Sub DisplayData2(ByVal ReceiveBuffer As String)
    'This delegate object marshals receive data from the receive thread context DataReceived to the Windows Form STAThread context
    Class DispClass
        Public Sub Disp(ByVal ReceiveBuffer As String)
            With DefInstance.txtTerm
                If .SelectionStart > 0 AndAlso _
                    .Text.Substring(.SelectionStart - 1) <> vbLf Then
                    ReceiveBuffer = ReceiveBuffer.Replace(vbLf, vbCr)
                ElseIf .SelectionStart > 0 Then
                    ReceiveBuffer = ReceiveBuffer.Replace(vbLf, "")
                End If
                ReceiveBuffer = ReceiveBuffer.Replace(vbCr & vbCr, vbCr)
                ReceiveBuffer = ReceiveBuffer.Replace(vbCr, vbCrLf)
                If Len(ReceiveBuffer) = 1 Then
                    If InStr(ReceiveBuffer, Chr(8)) > 0 Then
                        If (.Text.Length > 0) Then .Text = _
                            .Text.Remove(.Text.Length - 1, 1)
                    End If
                Else
                    .SelectionStart = .Text.Length
                    .SelectedText = ReceiveBuffer
                End If
                If .Text.Length > 4096 Then
                    .Text = Mid(.Text, 2048)
                    If Mid(.Text, 1) = vbLf Then _
                            .Text = Mid(.Text, 2)
                End If
                ReceiveBuffer = ""
            End With
        End Sub
    End Class

    Private Shared Sub DisplayData1(ByVal sender As Object, ByVal e As EventArgs)
        'This event handler marshals receive data from the receive thread context DataReceived to the Windows Form STAThread context
        'ReceiveBuffer has class scope
        With DefInstance.txtTerm
            If .SelectionStart > 0 AndAlso _
                .Text.Substring(.SelectionStart - 1) <> vbLf Then
                ReceiveBuffer = ReceiveBuffer.Replace(vbLf, vbCr)
            ElseIf .SelectionStart > 0 Then
                ReceiveBuffer = ReceiveBuffer.Replace(vbLf, "")
            End If
            ReceiveBuffer = ReceiveBuffer.Replace(vbCr & vbCr, vbCr)
            ReceiveBuffer = ReceiveBuffer.Replace(vbCr, vbCrLf)
            If Len(ReceiveBuffer) = 1 Then
                If InStr(ReceiveBuffer, Chr(8)) > 0 Then
                    If (.Text.Length > 0) Then .Text = _
                        .Text.Remove(.Text.Length - 1, 1)
                End If
            Else
                .SelectionStart = .Text.Length
                .SelectedText = ReceiveBuffer
            End If
            If .Text.Length > 4096 Then
                .Text = Mid(.Text, 2048)
                If Mid(.Text, 1) = vbLf Then _
                        .Text = Mid(.Text, 2)
            End If
        End With
    End Sub

    Public Delegate Sub DisplayData(ByVal Buffer As String)
    'This delegate routine marshals receive data from the receive thread context DataReceived to the Windows Form STAThread context
    Private Shared Sub Display(ByVal Buffer As String)
        With DefInstance.txtTerm
            If .SelectionStart > 0 AndAlso _
                .Text.Substring(.SelectionStart - 1) <> vbLf Then
                Buffer = Buffer.Replace(vbLf, vbCr)
            ElseIf .SelectionStart > 0 Then
                Buffer = Buffer.Replace(vbLf, "")
            End If
            Buffer = Buffer.Replace(vbCr & vbCr, vbCr)
            Buffer = Buffer.Replace(vbCr, vbCrLf)
            If (Buffer.Length = 1) And (Buffer = Chr(8)) Then
                If (.Text.Length > 0) Then .Text = _
                    .Text.Remove(.Text.Length - 1, 1)
            Else
                .SelectedText = Buffer
            End If
            If .Text.Length > 2048 Then
                .Text = .Text.Remove(0, 1024)
                If Mid(.Text, 1) = vbLf Then _
                        .Text = .Text.Remove(0, 1)
            End If
            .SelectionStart = .Text.Length
        End With
    End Sub

    Private Sub NETSerialTerm_FormClosing(ByVal sender As Object, ByVal e As _
    System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        With SerialPort
            If .IsOpen Then
                SerialPortClosing = True
                .DiscardInBuffer()
                .Close()
            End If
        End With
    End Sub

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        SerialPort = New SerialPort
        With SerialPort
            .DtrEnable = True
            .RtsEnable = True
            .Handshake = Handshake.RequestToSend
            .ReadBufferSize = 4096
            .RtsEnable = True
            .DtrEnable = True
        End With
        DefInstance = Me
    End Sub

    Private Shared Sub SerialPort_DataReceived(ByVal sender As Object, ByVal e As _
    System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort.DataReceived
        If DefInstance.SerialPortClosing = False Then
            If DefInstance.HexDisplayToolStripMenuItem.Checked = False Then
                If SerialPort.BytesToRead > 0 Then ReceiveBuffer = SerialPort.ReadExisting
                If DefInstance.TimeAtStart = 0 Then DefInstance.TimeAtStart = Now.TimeOfDay.TotalMilliseconds
                DefInstance.TotalBytes += ReceiveBuffer.Length
                'update the throughput calculation
                DefInstance.Throughput = DefInstance.TotalBytes / (Now.TimeOfDay.TotalMilliseconds - DefInstance.TimeAtStart)
            Else
                Dim Count As Integer = SerialPort.BytesToRead
                Dim Buffer(0 To Count - 1) As Byte
                Dim Text2Display As String = ""
                SerialPort.Read(Buffer, 0, Count)
                For I As Integer = 0 To Buffer.GetUpperBound(0)
                    Text2Display += Buffer(I).ToString("X2") & " "
                Next
                ReceiveBuffer = Text2Display
            End If
            If ReceiveBuffer <> "" Then
                'EACH OF THE FOLLOWING MARSHAL DATA TO THE UI, IN SLIGHTLY DIFFERENT WAYS
                'Dim DisplayData As DisplayData = AddressOf DispData.Disp
                'DefInstance.BeginInvoke(DisplayData, ReceiveBuffer)
                'DefInstance.BeginInvoke(New EventHandler(AddressOf DisplayData1))
                DefInstance.txtTerm.BeginInvoke(New DisplayData(AddressOf Display), ReceiveBuffer)

                'Give the UI a chance to catch up (streaming data) -- Sleep executes in the
                'SerialPort receive thread context
                Thread.Sleep(SerialPort.BaudRate \ 4800)  'empirical sleep value -- might depend on hardware
                'because the HexDisplay code is rather expensive (lots of strings are created and destroyed,
                'even this Thread.Sleep call does not allow sufficiently chunky operation.  Use the HexDisplay
                'function with care... It may appear to "lock up."

                'call the following code to handle the Coulter AcT Series Analyzer
                'it is a prototype parser, and might be used as a model for parsing regular ASCII data
                'DefInstance.Framer.DecodeFrame(ReceiveBuffer)
            End If
        End If
    End Sub

    Private Sub ExitToolStripMenuItem_Click(ByVal sender As _
    System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        Me.Close()
    End Sub

    Private Sub AboutToolStripMenuItem_Click(ByVal sender As _
    System.Object, ByVal e As System.EventArgs) Handles AboutToolStripMenuItem.Click
        MsgBox("NETSerialTerm is a simple terminal emulator that illustrates" & _
        vbCrLf & "the Visual Studio 2005 System.IO.Ports serial IO class." & vbCrLf _
        & "Copyright (c) 2006 by Richard L. Grier.")
    End Sub

    Private Sub SettingsToolStripMenuItem_Click(ByVal sender As _
    System.Object, ByVal e As System.EventArgs) Handles SettingsToolStripMenuItem.Click
        frmConfigScrn.ShowDialog()
        Me.Text = "NETSerialTerm using port: " & _
                    SerialPort.PortName
    End Sub

    Private Sub ClearScreenToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClearScreenToolStripMenuItem.Click
        txtTerm.Text = ""
    End Sub

    Private Sub HexDisplayToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HexDisplayToolStripMenuItem.Click
        With HexDisplayToolStripMenuItem
            .Checked = Not .Checked
        End With
    End Sub

    'the following are the prototypes for classes that might be used to decode 
    'instrument data from a Coulter AcT Series Analyzer

    Public Class ParseASTM1394
        'high-level protocol
        Public Header(0) As String
        Public Patient(0) As String
        Public TestOrder(0) As String
        Public Result() As String
        Public MeasageTerminator(0) As String
        Private Buffer As String
        Public Function Parse(ByVal Data2Parse As String) As Boolean
            Dim Fields() As String
            Buffer += Data2Parse
            Fields = Buffer.Split(vbCrLf)
            If Fields(0).StartsWith("H") Then
                If Fields(Fields.Length - 1).StartsWith("L") Then
                    'we may parse the rest of the data
                    'in each field by Spliting it on the "|" character
                    'into separate contents
                    Header(0) = Fields(0)
                    Patient(0) = Fields(1)
                    TestOrder(0) = Fields(2)
                    Dim FieldCount As Integer = 2
                    Do
                        FieldCount += 1
                        If Fields(FieldCount).StartsWith("P") Then
                            ReDim Preserve Patient(Patient.Length)
                            Patient(Patient.Length - 1) = Fields(FieldCount)
                        Else
                            Exit Do
                        End If
                    Loop
                    MeasageTerminator(0) = Fields(FieldCount)
                    Buffer = ""
                    Return True
                End If
            Else
                Buffer = ""
                Return False
            End If
        End Function
    End Class

    Public Class ParseASTM1381   'low-level communications protocol
        Private Buffer As String
        Private Const STX As Char = Chr(2)
        Private Const ETX As Char = Chr(3)
        Private Const ETB As Char = Chr(23)
        Private FN As String
        Private C1C2 As String
        Event FrameDecoded(ByVal Frame As String, ByVal IntermediateFrame As Boolean)

        Public Function DecodeFrame(ByVal ReceiveData) As Boolean
            Dim Text As String
            Dim IntermediateFrame As Boolean
            'Intermediate Frame. Terminates with the characters <ETB>, two-character checksum,
            '<CR> and <LF>. The frame structure is as follows: <STX> FN text <ETB> C1 C2 <CR> <LF>
            'End Frame. Terminates with the characters <ETX>, two-character checksum, <CR> and
            '<LF>. The frame structure is as follows: <STX> FN text <ETX> C1 C2 <CR> <LF>
            Buffer += ReceiveData
            If Buffer.StartsWith(STX) = False Then
                Buffer = ""
            Else
                If Buffer.EndsWith(vbCrLf) Then
                    Dim FrameNumber As String = Mid(Buffer, 2, 1)
                    If FrameNumber = FN Then
                        'data has been retransmitted
                    Else
                        'new data
                    End If
                    FN = FrameNumber
                    If InStr(Buffer, ETB) Then
                        Text = Mid(Buffer, 3, InStr(Buffer, ETB) - 1)
                        C1C2 = Mid$(Buffer, InStr(Buffer, ETB) + 1, 2)
                        IntermediateFrame = True
                    Else
                        Text = Mid(Buffer, 3, InStr(Buffer, ETX) - 1)
                        C1C2 = Mid$(Buffer, InStr(Buffer, ETX) + 1, 2)
                        IntermediateFrame = False
                    End If
                    Buffer = ""
                    RaiseEvent FrameDecoded(Text, IntermediateFrame)
                    Return True
                End If
            End If
        End Function
    End Class

    Private Sub Framer_FrameDecoded(ByVal Frame As String, ByVal IntermediateFrame As Boolean) Handles Framer.FrameDecoded
        Static Buffer As String
        Buffer += Text
        If IntermediateFrame = False Then
            'finished!
            If Parser.Parse(Buffer) = True Then
                'you can use the properties of the Parser to separate item data here
            Else
                'this should not happen, but if it does, you can start debugging
            End If
        End If
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        txtTerm.SelectedText = vbCrLf & "Throughput (characters per second)= " & CStr(Throughput * 1000)
    End Sub

    Private Shared Sub SerialPort_ErrorReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialErrorReceivedEventArgs) Handles SerialPort.ErrorReceived
        Debug.WriteLine(e.EventType.ToString)
    End Sub
End Class
