Imports System.Threading
Imports System.Globalization
Public Class DecodeGPS
    Private m_Latitude As String
    Private m_Longitude As String
    Private m_UTCTime As String
    Private m_LatitudeHemisphere As String
    Private m_LongitudeHemisphere As String
    Private m_UTCDate As String
    Private m_CourseOverGround As String
    Private m_SpeedOverGround As String
    Private m_LocalTime As String
    Private m_LocalDate As String
    Private m_Status As String
    Private m_DecimalLat As Double
    Private m_DecimalLon As Double
    Private m_DateSeparator As Char
    Private m_Altitude As String
    Private m_NumberOfSatellites As String

    Public Event GPSDecoded(ByVal Status As Boolean)

    Public ReadOnly Property NumberOfSatellites() As String
        Get
            SyncLock Me
                Return m_NumberOfSatellites
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property Altitude() As String
        Get
            SyncLock Me
                Return m_Altitude
            End SyncLock
        End Get
    End Property

    Public ReadOnly Property DecimalLatitude() As Double
        Get
            SyncLock Me
                Return m_DecimalLat
            End SyncLock
        End Get
    End Property

    Public ReadOnly Property DecimalLongitude() As Double
        Get
            SyncLock Me
                Return m_DecimalLon
            End SyncLock
        End Get
    End Property

    Public ReadOnly Property Status() As String
        Get
            SyncLock Me
                Return m_Status
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property Latitude() As String
        Get
            SyncLock Me
                Return m_Latitude
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property Longitude() As String
        Get
            SyncLock Me
                Return m_Longitude
            End SyncLock

        End Get
    End Property
    Public ReadOnly Property UTCTime() As String
        Get
            SyncLock Me
                Return m_UTCTime
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property LatitudeHemisphere() As String
        Get
            SyncLock Me
                Return m_LatitudeHemisphere
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property LongitudeHemisphere() As String
        Get
            SyncLock Me
                Return m_LongitudeHemisphere
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property UTCDate() As String
        Get
            SyncLock Me
                Return m_UTCDate
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property CourseOverGround() As String
        Get
            SyncLock Me
                Return m_CourseOverGround
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property SpeedOverGround() As String
        Get
            SyncLock Me
                Return m_SpeedOverGround
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property LocalTime() As String
        Get
            SyncLock Me
                Return m_LocalTime
            End SyncLock
        End Get
    End Property
    Public ReadOnly Property LocalDate() As String
        Get
            SyncLock Me
                Return m_LocalDate
            End SyncLock
        End Get
    End Property

    Public Sub GPSStream(ByVal GPSData As String)
        Static Buffer As String

        Dim Delimiter() As Char = ",".ToCharArray
        Dim SplitGPRMC() As String
        Dim UTCDateTime As DateTime
        Dim SplitGPGGA() As String

        Buffer += GPSData
        'Do we have a complete $GPRMC sentence?
        If (Buffer.IndexOf("GPRMC") > 0) AndAlso _
            (Buffer.IndexOf(vbCrLf, Buffer.IndexOf("GPRMC")) > 0) _
            AndAlso (Buffer.IndexOf("GPGGA") > 0) AndAlso _
            (Buffer.IndexOf(vbCrLf, Buffer.IndexOf("GPGGA")) > 0) Then
            Dim SubBuffer As String = _
                    Buffer.Substring(Buffer.IndexOf("GPRMC"))
            SplitGPRMC = SubBuffer.Split(Delimiter)
            SyncLock Me
                m_UTCTime = SplitGPRMC(1)
                m_Status = SplitGPRMC(2)
                m_Latitude = SplitGPRMC(3)
                m_LatitudeHemisphere = SplitGPRMC(4)
                m_Longitude = SplitGPRMC(5)
                m_LongitudeHemisphere = SplitGPRMC(6)
                m_SpeedOverGround = SplitGPRMC(7)
                m_CourseOverGround = SplitGPRMC(8)
                m_UTCDate = SplitGPRMC(9)
                Dim TimeString As String = m_UTCTime.Substring(0, 2) _
                        & ":" & m_UTCTime.Substring(2, 2) & ":" _
                        & m_UTCTime.Substring(4, 2)
                Dim DateString As String = m_UTCDate.Substring(2, 2) _
                        & m_DateSeparator & m_UTCDate.Substring(0, 2) & _
                        m_DateSeparator & "20" & m_UTCDate.Substring(4, 2)
                Try
                    UTCDateTime = CDate(DateString & " " & TimeString)
                Catch ex As Exception
                End Try
                m_LocalTime = TimeZone.CurrentTimeZone.ToLocalTime _
                                (UTCDateTime).ToLongTimeString
                m_LocalDate = TimeZone.CurrentTimeZone.ToLocalTime _
                                (UTCDateTime).ToShortDateString
                m_DecimalLat = CDbl(Latitude.Substring(0, 2)) + (CDbl(Latitude.Substring(2) / 60))
                Dim DecimalPoint As Integer = Longitude.IndexOf(".")
                m_DecimalLon = CDbl(Longitude.Substring(0, DecimalPoint - 2)) + CDbl(Longitude.Substring(DecimalPoint - 2) / 60)
                If LongitudeHemisphere = "W" Then m_DecimalLon = -1 * m_DecimalLon
                SubBuffer = Buffer.Substring(Buffer.IndexOf("GPGGA"))
                SplitGPGGA = SubBuffer.Split(Delimiter)
                m_NumberOfSatellites = SplitGPGGA(7)
                m_Altitude = SplitGPGGA(9)
            End SyncLock
            If m_Status = "A" Then
                RaiseEvent GPSDecoded(True)
            Else
                RaiseEvent GPSDecoded(False)
            End If
            Buffer = ""
        End If
    End Sub

    Public Sub New()
        Dim culture As CultureInfo = CultureInfo.CurrentCulture
        m_DateSeparator = culture.DateTimeFormat.DateSeparator
    End Sub
End Class

