Public Class Form1

    Private Sub TestForm_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        With SerialPort
            If .IsOpen Then
                .CancelTransfer()  'just in case
                .Close()
            End If
        End With
    End Sub
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        With SerialPort
            Try
                .PortName = "Com1"       'use an approriate port number
                .BaudRate = 115200
                .UseCRC = False
                .RtsEnable = True
                .DtrEnable = True
                .ReceivedBytesThreshold = 1
                .Open()
            Catch ex As Exception
            Finally
                If .IsOpen = False Then MsgBox("Unable to open port.", MsgBoxStyle.Information)
            End Try
        End With
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        With SerialPort
            .SendFilename = "C:\Test.zip"
            Me.Text = "Transfer Started"
            .SendFile()
        End With
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        With SerialPort
            .ReceiveFilename = "C:\Test.zip"
            Me.Text = "Transfer Started"
            .ReceiveFile()
        End With
    End Sub

    Private Sub SerialPort_DataReceived(ByVal sender As Object, ByVal e As System.IO.Ports.SerialDataReceivedEventArgs) Handles SerialPort.DataReceived
        If SerialPort.TransferStarted Then Exit Sub
        'add any other code here that you may need
    End Sub

    Private Sub SerialPort_TransferStatusChange(ByVal Sender As Object, ByVal e As System.EventArgs) Handles SerialPort.TransferStatusChange
        Me.Text = "Transfered bytes: " & SerialPort.BytesTransfered.ToString
    End Sub
End Class
