﻿Imports System.Text
Imports System.Threading
Imports System.IO.Ports

'Attention:  Use of the Watchdog function may result in loss of data!
'Copyright (C) Richard L. Grier 2010

Public Class TestEnhanced
    Public WithEvents SerialPort As New EnhancedSerialPort.SerialPort
    Private Shared m_FormDefInstance As TestEnhanced
    Private Shared m_InitializingDefInstance As Boolean
    Private Shared SerialPortClosing As Boolean
    Private Shared ReceiveBuffer As String = ""
    Private Shared Data2Display As New StringBuilder(4096)
    Private Shared DispData As New DispClass

    Public Shared Property DefInstance() As TestEnhanced
        Get
            If m_FormDefInstance Is Nothing OrElse _
                        m_FormDefInstance.IsDisposed Then
                m_InitializingDefInstance = True
                m_FormDefInstance = New TestEnhanced
                m_InitializingDefInstance = False
            End If
            DefInstance = m_FormDefInstance
        End Get
        Set(ByVal Value As TestEnhanced)
            m_FormDefInstance = Value
        End Set
    End Property

    Private Sub txtTerm_KeyPress(ByVal sender As Object, ByVal e As  _
    System.Windows.Forms.KeyPressEventArgs) Handles txtTerm.KeyPress
        Dim KeyAscii As Int32 = Asc(e.KeyChar)
        With SerialPort
            If .IsOpen = True Then
                .Write(Chr(KeyAscii))
            End If
        End With
        e.Handled = True
    End Sub

    Private Delegate Sub DisplayData2(ByVal ReceiveBuffer As String)
    'This delegate object marshals receive data from the receive thread context DataReceived to the Windows Form STAThread context
    Class DispClass
        Public Sub Disp(ByVal ReceiveBuffer As String)
            With DefInstance.txtTerm
                If .SelectionStart > 0 AndAlso _
                    .Text.Substring(.SelectionStart - 1) <> vbLf Then
                    ReceiveBuffer = ReceiveBuffer.Replace(vbLf, vbCr)
                ElseIf .SelectionStart > 0 Then
                    ReceiveBuffer = ReceiveBuffer.Replace(vbLf, "")
                End If
                ReceiveBuffer = ReceiveBuffer.Replace(vbCr & vbCr, vbCr)
                ReceiveBuffer = ReceiveBuffer.Replace(vbCr, vbCrLf)
                If Len(ReceiveBuffer) = 1 Then
                    If InStr(ReceiveBuffer, Chr(8)) > 0 Then
                        If (.Text.Length > 0) Then .Text = _
                            .Text.Remove(.Text.Length - 1, 1)
                    End If
                Else
                    .SelectionStart = .Text.Length
                    .SelectedText = ReceiveBuffer
                End If
                If .Text.Length > 4096 Then
                    .Text = Mid(.Text, 2048)
                    If Mid(.Text, 1) = vbLf Then _
                            .Text = Mid(.Text, 2)
                End If
                ReceiveBuffer = ""
            End With
        End Sub
    End Class

    Private Shared Sub DisplayData1(ByVal sender As Object, ByVal e As EventArgs)
        'This event handler marshals receive data from the receive thread context DataReceived to the Windows Form STAThread context
        'ReceiveBuffer has class scope
        With DefInstance.txtTerm
            If .SelectionStart > 0 AndAlso _
                .Text.Substring(.SelectionStart - 1) <> vbLf Then
                ReceiveBuffer = ReceiveBuffer.Replace(vbLf, vbCr)
            ElseIf .SelectionStart > 0 Then
                ReceiveBuffer = ReceiveBuffer.Replace(vbLf, "")
            End If
            ReceiveBuffer = ReceiveBuffer.Replace(vbCr & vbCr, vbCr)
            ReceiveBuffer = ReceiveBuffer.Replace(vbCr, vbCrLf)
            If Len(ReceiveBuffer) = 1 Then
                If InStr(ReceiveBuffer, Chr(8)) > 0 Then
                    If (.Text.Length > 0) Then .Text = _
                        .Text.Remove(.Text.Length - 1, 1)
                End If
            Else
                .SelectionStart = .Text.Length
                .SelectedText = ReceiveBuffer
            End If
            If .Text.Length > 4096 Then
                .Text = Mid(.Text, 2048)
                If Mid(.Text, 1) = vbLf Then _
                        .Text = Mid(.Text, 2)
            End If
        End With
    End Sub

    Public Delegate Sub DisplayData(ByVal Buffer As String)
    'This delegate routine marshals receive data from the receive thread context DataReceived to the Windows Form STAThread context
    Private Shared Sub Display(ByVal Buffer As String)
        With DefInstance.txtTerm
            If .SelectionStart > 0 AndAlso _
                .Text.Substring(.SelectionStart - 1) <> vbLf Then
                Buffer = Buffer.Replace(vbLf, vbCr)
            ElseIf .SelectionStart > 0 Then
                Buffer = Buffer.Replace(vbLf, "")
            End If
            Buffer = Buffer.Replace(vbCr & vbCr, vbCr)
            Buffer = Buffer.Replace(vbCr, vbCrLf)
            .SelectedText = Buffer
        End With
    End Sub

    Private Sub TestEnhanced_FormClosing(ByVal sender As Object, ByVal e As  _
    System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        With SerialPort
            Try
                If .IsOpen Then
                    .Close()
                End If
            Catch ex As Exception
            End Try
        End With
    End Sub

    Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        SerialPort = New EnhancedSerialPort.SerialPort
        With SerialPort
            .DTREnable = True
            .RTSEnable = True
            '.Handshake = IO.Ports.Handshake.RequestToSend
            .ReadBufferSize = 4096
            .ReceivedBytesThreshold = 1
        End With
        DefInstance = Me
    End Sub

    Private Sub ExitToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExitToolStripMenuItem.Click
        Me.Close()
    End Sub

    Private Sub PortOpenToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles PortOpenToolStripMenuItem.Click
        Dim ex As Exception
        With SerialPort
            If .IsOpen = False Then
                Try
                    .Open()
                Catch ex
                End Try
            Else
                Try
                    SerialPortClosing = True
                    .Close()
                Catch ex
                End Try
            End If
            If .IsOpen = True Then
                PortOpenToolStripMenuItem.Checked = True
                Me.Text = "TestEnhanced using port: " & _
                                    SerialPort.PortName
                .ReceivedBytesThreshold = 1
                SerialPortClosing = False
            Else
                PortOpenToolStripMenuItem.Checked = False
                Me.Text = "TestEnhanced not running"
                SerialPortClosing = True
            End If
        End With
    End Sub

    Private Sub SettingsToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles SettingsToolStripMenuItem.Click
        frmConfigScrn.ShowDialog()
        Me.Text = "TestEnhanced using port: " & _
                    SerialPort.PortName
    End Sub

    Private Sub ClearScreenToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ClearScreenToolStripMenuItem.Click
        txtTerm.Text = ""
    End Sub

    Private Sub HexDisplayToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles HexDisplayToolStripMenuItem.Click
        With HexDisplayToolStripMenuItem
            .Checked = Not .Checked
        End With
    End Sub

    Private Sub AboutToolStripMenuItem_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AboutToolStripMenuItem.Click
        MsgBox("TestEnhanced is a simple terminal emulator that illustrates" & _
        vbCr & "an EnhancedSerialPort class -- with watchdog function." & vbCr _
        & "The Watchdog is designed to reconnect a serial port, if that connection is lost." _
        & vbCr & "This might happen if a USB serial adapter is removed then is reinserted." & vbCr & vbCr & _
        "Copyright (c) 2006-2010 by Richard L. Grier.")
    End Sub

    Private Sub SerialPort_DataReceived() Handles SerialPort.DataReceived
        If DefInstance.HexDisplayToolStripMenuItem.Checked = False Then
            If SerialPort.BytesToRead > 0 Then ReceiveBuffer = SerialPort.ReadExisting
        Else
            Dim Count As Integer = SerialPort.BytesToRead
            Dim Buffer(0 To Count - 1) As Byte
            Dim Text2Display As String = ""
            SerialPort.Read(Buffer, 0, Count)
            For I As Integer = 0 To Buffer.GetUpperBound(0)
                Text2Display += Buffer(I).ToString("X2") & " "
            Next
            ReceiveBuffer = Text2Display
        End If
        If ReceiveBuffer <> "" Then
            'EACH OF THE FOLLOWING MARSHAL DATA TO THE UI, IN SLIGHTLY DIFFERENT WAYS
            'Dim DisplayData As DisplayData = AddressOf DispData.Disp
            'DefInstance.BeginInvoke(DisplayData, ReceiveBuffer)
            'DefInstance.BeginInvoke(New EventHandler(AddressOf DisplayData1))
            DefInstance.txtTerm.BeginInvoke(New DisplayData(AddressOf Display), ReceiveBuffer)
        End If
    End Sub

    Private Sub SerialPort_ErrorReceived(ByVal e As System.IO.Ports.SerialErrorReceivedEventArgs) Handles SerialPort.ErrorReceived
        Debug.WriteLine(e.EventType.ToString)
    End Sub

    Private Sub SerialPort_PinChanged(ByVal e As System.IO.Ports.SerialPinChangedEventArgs) Handles SerialPort.PinChanged
        If System.IO.Ports.SerialPinChange.DsrChanged = SerialPinChange.DsrChanged Then
            If SerialPort.DSRHolding = True Then
                Label1.BackColor = Color.Green
            ElseIf SerialPort.DSRHolding = False Then
                Label1.BackColor = Color.Red
            End If
        End If
        If System.IO.Ports.SerialPinChange.DsrChanged = SerialPinChange.CtsChanged Then
            If SerialPort.CTSHolding = True Then
                Label2.BackColor = Color.Green
            ElseIf SerialPort.DSRHolding = False Then
                Label2.BackColor = Color.Red
            End If
        End If
        If System.IO.Ports.SerialPinChange.DsrChanged = SerialPinChange.CDChanged Then
            If SerialPort.CDHolding = True Then
                Label3.BackColor = Color.Green
            ElseIf SerialPort.DSRHolding = False Then
                Label3.BackColor = Color.Red
            End If
        End If
        If System.IO.Ports.SerialPinChange.DsrChanged = SerialPinChange.Ring Then
            Label4.BackColor = Color.CornflowerBlue
            Thread.Sleep(100)
            Label4.BackColor = Color.Red
        End If
    End Sub

    Private Sub SerialPort_Watchdog(ByVal Flag As EnhancedSerialPort.SerialPort.WatchdogFlags) Handles SerialPort.Watchdog
        Debug.Print(Flag.ToString)
        DefInstance.txtTerm.BeginInvoke(New DisplayWatchdog(AddressOf DisplayWD), Flag.ToString)
    End Sub

    Public Delegate Sub DisplayWatchdog(ByVal WDError As String)
    'This delegate routine marshals a watchdog flag from the receive thread context Watchdog event to the Windows Form STAThread context
    Private Shared Sub DisplayWD(ByVal WDError As String)
        With DefInstance.SerialPort
            If .IsOpen Then
                DefInstance.txtTerm.Text = "Watchdog reopen successful on " & .PortName & vbCrLf
                DefInstance.txtTerm.SelectionStart = DefInstance.txtTerm.Text.Length
            Else
                DefInstance.txtTerm.Text = "Watchdog event: " & WDError
            End If
        End With
    End Sub

    Private Sub ChooseTerminalFontToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ChooseTerminalFontToolStripMenuItem.Click
        FontDialog1.ShowDialog()
        txtTerm.Font = FontDialog1.Font
    End Sub
End Class
