VERSION 5.00
Begin VB.UserControl LongTimer 
   ClientHeight    =   480
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   480
   HasDC           =   0   'False
   InvisibleAtRuntime=   -1  'True
   Picture         =   "LongTimer.ctx":0000
   ScaleHeight     =   480
   ScaleWidth      =   480
   ToolboxBitmap   =   "LongTimer.ctx":0742
   Windowless      =   -1  'True
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   100
      Left            =   300
      Top             =   210
   End
End
Attribute VB_Name = "LongTimer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

Private Declare Function timeGetTime Lib "winmm.dll" () As Long

Private m_Interval As Single
Private m_Count As Single
Private m_LastTime As Single
Public Event OnTimer()

Private Sub Timer1_Timer()
Dim NowTime As Single
Dim TimeDiff As Single
    NowTime = timeGetTime
    TimeDiff = NowTime - m_LastTime
    If NowTime - m_LastTime < NowTime Then
        If TimeDiff > 100 Then
            If TimeDiff - Timer1.Interval < 55 Then
                Timer1.Interval = Timer1.Interval - NowTime + m_LastTime + Timer1.Interval
            Else
                Timer1.Interval = 55
            End If
        Else
            Timer1.Interval = 100
        End If
    End If
    If m_Interval > 0 And m_LastTime > 0 Then
        m_Count = m_Count + TimeDiff / 1000
        If m_Count >= m_Interval Then
            RaiseEvent OnTimer
            m_Count = m_Count - m_Interval
        End If
    End If
    m_LastTime = NowTime
End Sub

Public Property Get Interval() As Single
    Interval = m_Interval
End Property

Public Property Let Interval(ByVal NewValue As Single)
    m_Interval = Val(Format$(NewValue, ".000"))
End Property

Public Property Get Enabled() As Boolean
    Enabled = Timer1.Enabled
End Property

Public Property Let Enabled(ByVal NewValue As Boolean)
    Timer1.Enabled = NewValue
End Property

Private Sub UserControl_Initialize()
    About
End Sub

Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    Me.Interval = Val(PropBag.ReadProperty("Interval", "0"))
    If PropBag.ReadProperty("Enabled", "False") = "True" Then
        Timer1.Enabled = True
    Else
        Timer1.Enabled = False
    End If
End Sub

Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    PropBag.WriteProperty "Interval", Format$(Me.Interval)
    If Timer1.Enabled = True Then PropBag.WriteProperty "Enabled", "True"
End Sub

Public Sub About()
    MsgBox "LongTimer OCX" & vbLf & vbLf & _
        "Copyright 2000 by Richard Grier" & vbLf & vbLf & _
        "Hard & Software" & vbLf & "12962 West Louisiana Avenue" & vbLf & _
        "Lakewood, CO  80228" & vbLf & "303-986-2179 (voice)" & vbLf & _
        "303-986-3214 (fax)" & vbLf & vbLf & "http://www.hardandsoftware.net"
End Sub

