Imports DesktopSerialIO.SerialIO.SerialPort
Imports DecodeGPS.DecodeGPS
Public Class frmGPSMP
    Inherits System.Windows.Forms.Form
    Friend objMap As MapPoint.Map
    Private objVehicle As MapPoint.Pushpin
    Private Filenum As Integer
    Private ExePath As String
    Private WithEvents DecodeGPS As New DecodeGPS.DecodeGPS
    Private WithEvents SerialPort As New DesktopSerialIO.SerialIO.SerialPort

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents AxMappointControl1 As AxMapPoint.AxMappointControl
    Friend WithEvents Button1 As System.Windows.Forms.Button
    Friend WithEvents txtCommPort As System.Windows.Forms.TextBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents Button2 As System.Windows.Forms.Button
    Friend WithEvents Timer1 As System.Windows.Forms.Timer
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(frmGPSMP))
        Me.AxMappointControl1 = New AxMapPoint.AxMappointControl
        Me.Button1 = New System.Windows.Forms.Button
        Me.txtCommPort = New System.Windows.Forms.TextBox
        Me.Label1 = New System.Windows.Forms.Label
        Me.Button2 = New System.Windows.Forms.Button
        Me.Timer1 = New System.Windows.Forms.Timer(Me.components)
        CType(Me.AxMappointControl1, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'AxMappointControl1
        '
        Me.AxMappointControl1.Enabled = True
        Me.AxMappointControl1.Location = New System.Drawing.Point(0, 0)
        Me.AxMappointControl1.Name = "AxMappointControl1"
        Me.AxMappointControl1.OcxState = CType(resources.GetObject("AxMappointControl1.OcxState"), System.Windows.Forms.AxHost.State)
        Me.AxMappointControl1.Size = New System.Drawing.Size(576, 352)
        Me.AxMappointControl1.TabIndex = 0
        '
        'Button1
        '
        Me.Button1.Location = New System.Drawing.Point(480, 360)
        Me.Button1.Name = "Button1"
        Me.Button1.TabIndex = 2
        Me.Button1.Text = "Start GPS"
        '
        'txtCommPort
        '
        Me.txtCommPort.Location = New System.Drawing.Point(392, 360)
        Me.txtCommPort.Name = "txtCommPort"
        Me.txtCommPort.Size = New System.Drawing.Size(16, 20)
        Me.txtCommPort.TabIndex = 3
        Me.txtCommPort.Text = "6"
        '
        'Label1
        '
        Me.Label1.Location = New System.Drawing.Point(320, 360)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(72, 23)
        Me.Label1.TabIndex = 4
        Me.Label1.Text = "PortNumber"
        '
        'Button2
        '
        Me.Button2.Location = New System.Drawing.Point(13, 360)
        Me.Button2.Name = "Button2"
        Me.Button2.TabIndex = 5
        Me.Button2.Text = "Simulate"
        '
        'Timer1
        '
        Me.Timer1.Interval = 1000
        '
        'frmGPSMP
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(568, 390)
        Me.Controls.Add(Me.Button2)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.txtCommPort)
        Me.Controls.Add(Me.Button1)
        Me.Controls.Add(Me.AxMappointControl1)
        Me.MaximizeBox = False
        Me.Name = "frmGPSMP"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "GPS Decoder With MapPoint 2004"
        CType(Me.AxMappointControl1, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ExePath = System.Windows.Forms.Application.StartupPath
        With SerialPort
            .RTSEnable = True
            .DTREnable = True
            .CTSHandshaking = False
            .EnableOnComm = True
            .BitRate = 4800
        End With
        With AxMappointControl1
            Dim objLoc As MapPoint.Location
            'Open a North American map
            .NewMap(MapPoint.GeoMapRegion.geoMapNorthAmerica)
            'Set the map object to the current map
            objMap = AxMappointControl1.ActiveMap
            objMap.MapStyle = MapPoint.GeoMapStyle.geoMapStyleTerrain
            'Set the font to the smallest size
            objMap.MapFont = MapPoint.GeoMapFont.geoMapFontSmallest
            'Add a symbol that will be used to show a vehicle location
            objMap.Symbols.Add(ExePath & "\USA14.ico")  '336
            objMap.Altitude = 6
            'set map starting point
            objLoc = objMap.GetLocation(39.625, -104.874, 6)
            objLoc.GoTo()
        End With
    End Sub

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        With SerialPort
            Try
                .CommPort = CInt(txtCommPort.Text)
            Catch ex As Exception
                txtCommPort.Text = ""
            End Try
            If .PortOpen = False Then .PortOpen = True
            If .PortOpen = False Then
                MsgBox("Unable to open the serial port", MsgBoxStyle.Critical)
            End If
        End With
    End Sub

    Private Sub frmGPSMP_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        If SerialPort.PortOpen = True Then SerialPort.PortOpen = False
        objMap.Saved = True
    End Sub

    Private Sub DecodeGPS_GPSDecoded(ByVal Status As Boolean) Handles DecodeGPS.GPSDecoded
        Dim objLoc As MapPoint.Location
        objMap = AxMappointControl1.ActiveMap
        With DecodeGPS
            Try
                objLoc = objMap.GetLocation(.DecimalLatitude, .DecimalLongitude)
                objLoc.GoTo()
                objMap.GoForward()
            Catch ex As Exception
            End Try
            DeleteVehicle()
            If Status = True Then CreateVehicle(objLoc)
        End With
    End Sub

    Private Sub DeleteVehicle()
        On Error Resume Next
        If Not (objVehicle Is Nothing) Then
            objVehicle.Delete()
            objVehicle = Nothing
        End If
    End Sub

    Private Sub CreateVehicle(ByVal objLoc As MapPoint.Location)
        ' Create a new pushpin
        objVehicle = objMap.AddPushpin(objLoc, "")
        ' Change pushpin symbol (the one we added for this purpose)
        objVehicle.Symbol = 336
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Button2.Enabled = False
        Button1.Enabled = False
        Filenum = FreeFile()
        FileOpen(Filenum, "gps.txt", OpenMode.Input)   ' Open file.
        Timer1.Enabled = True
    End Sub

    Private Sub Timer1_Tick(ByVal sender As Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        Dim I As Integer
        Dim GPSSentence As String
        For I = 1 To 8
            If EOF(Filenum) = False Then
                GPSSentence = LineInput(Filenum) & vbCrLf
                DecodeGPS.GPSStream(GPSSentence)
            Else
                MsgBox("Finished")
                Button2.Enabled = True
                Button1.Enabled = True
                Timer1.Enabled = False
                FileClose(Filenum)
            End If
        Next
    End Sub

    Private Sub SerialPort_OnComm() Handles SerialPort.OnComm
        Dim Buffer As String = SerialPort.InputString
        If Buffer.Length > 0 Then DecodeGPS.GPSStream(Buffer)
    End Sub
End Class
