Public Class Form1

    Private Sub Form1_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        GpsControl1.GPSEnable(False)
    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        GpsControl1.Visible = False
        GpsControl1.About()
    End Sub

    Private Sub GpsControl1_GPSDecoded(ByVal Status As Boolean) Handles GpsControl1.GPSDecoded
        With GpsControl1
            If Status = False Then
                GPSData.Text = "GPS Status: Violation.  A valid navigation solution is not possible." _
                & vbCrLf & "Current Date: " & .LocalDate & vbCrLf & "Current Time: " & .LocalTime & vbCrLf _
                & "Number of Satellites in Use: " & .NumberOfSatellites
            Else
                GPSData.Text = ""
                GPSData.SelectedText = "Latitude: " & .Latitude & vbCrLf
                GPSData.SelectedText = "Longitude: " & .Longitude & vbCrLf
                GPSData.SelectedText = "Universal Time: " & .UTCTime & vbCrLf
                GPSData.SelectedText = "Universal Date: " & .UTCDate & vbCrLf
                GPSData.SelectedText = "Local Time: " & .LocalTime & vbCrLf
                GPSData.SelectedText = "Local Date: " & .LocalDate & vbCrLf
                GPSData.SelectedText = "Latitude Hemisphere: " & .LatitudeHemisphere & vbCrLf
                GPSData.SelectedText = "Longitude Hemisphere: " & .LongitudeHemisphere & vbCrLf
                GPSData.SelectedText = "Course Over Ground: " & .CourseOverGround & vbCrLf
                GPSData.SelectedText = "Speed Over Ground (knots): " & .SpeedOverGround & vbCrLf
                GPSData.SelectedText = "Decimal Latitude: " & .DecimalLatitude.ToString & vbCrLf
                GPSData.SelectedText = "Decimal Longitude: " & .DecimalLongitude.ToString & vbCrLf
                GPSData.SelectedText = "Altitude (meters): " & .Altitude & vbCrLf
                GPSData.SelectedText = "Number of Satellites in Use: " & .NumberOfSatellites
            End If
        End With
    End Sub

    Private Sub EnableToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles EnableToolStripMenuItem.Click
        With EnableToolStripMenuItem
            GPSData.Cursor = Cursors.WaitCursor
            Me.Refresh()
            If .Checked = False Then
                If GpsControl1.GPSEnable(True) = True Then
                    .Checked = True
                    GPSStatus.Text = GpsControl1.GPSPortData
                End If
            Else
                GpsControl1.GPSEnable(False)
                .Checked = False
                GPSStatus.Text = GpsControl1.GPSPortData
                GPSData.Text = ""
            End If
            GPSData.Cursor = Cursors.Default
        End With
    End Sub

    Private Sub AboutToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles AboutToolStripMenuItem.Click
        GpsControl1.About()
    End Sub
End Class
