Option Strict On
Option Explicit On 

Imports CFSerialClass
Imports System.Text
Imports System.Threading

Public Class CFNETTerm
    Inherits System.Windows.Forms.Form
    Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        MyBase.Dispose(disposing)
    End Sub

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents txtTerm As System.Windows.Forms.TextBox
    Friend WithEvents chkDTR As System.Windows.Forms.CheckBox
    Friend WithEvents chkRTS As System.Windows.Forms.CheckBox
    Friend WithEvents chkEnableOnComm As System.Windows.Forms.CheckBox
    Friend WithEvents Button1 As System.Windows.Forms.Button
    Friend WithEvents Button2 As System.Windows.Forms.Button
    Friend WithEvents txtHW As System.Windows.Forms.TextBox
    Friend WithEvents Button3 As System.Windows.Forms.Button
    Friend WithEvents Button4 As System.Windows.Forms.Button
    Friend WithEvents Button5 As System.Windows.Forms.Button
    Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
    Friend WithEvents MenuItem16 As System.Windows.Forms.MenuItem
    Friend WithEvents Button6 As System.Windows.Forms.Button
    Friend WithEvents Button7 As System.Windows.Forms.Button
    Friend WithEvents SaveFileDialog1 As System.Windows.Forms.SaveFileDialog
    Friend WithEvents MainMenu2 As System.Windows.Forms.MainMenu
    Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem3 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem4 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem5 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem6 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem7 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem8 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem9 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem10 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem11 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem12 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem13 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem14 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem15 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem17 As System.Windows.Forms.MenuItem
    Friend WithEvents MenuItem18 As System.Windows.Forms.MenuItem
    Private Sub InitializeComponent()
        Me.txtTerm = New System.Windows.Forms.TextBox
        Me.MenuItem16 = New System.Windows.Forms.MenuItem
        Me.chkDTR = New System.Windows.Forms.CheckBox
        Me.chkRTS = New System.Windows.Forms.CheckBox
        Me.chkEnableOnComm = New System.Windows.Forms.CheckBox
        Me.Button1 = New System.Windows.Forms.Button
        Me.Button2 = New System.Windows.Forms.Button
        Me.txtHW = New System.Windows.Forms.TextBox
        Me.Button3 = New System.Windows.Forms.Button
        Me.Button4 = New System.Windows.Forms.Button
        Me.Button5 = New System.Windows.Forms.Button
        Me.TextBox1 = New System.Windows.Forms.TextBox
        Me.Button6 = New System.Windows.Forms.Button
        Me.Button7 = New System.Windows.Forms.Button
        Me.SaveFileDialog1 = New System.Windows.Forms.SaveFileDialog
        Me.MainMenu2 = New System.Windows.Forms.MainMenu
        Me.MenuItem1 = New System.Windows.Forms.MenuItem
        Me.MenuItem3 = New System.Windows.Forms.MenuItem
        Me.MenuItem4 = New System.Windows.Forms.MenuItem
        Me.MenuItem5 = New System.Windows.Forms.MenuItem
        Me.MenuItem6 = New System.Windows.Forms.MenuItem
        Me.MenuItem7 = New System.Windows.Forms.MenuItem
        Me.MenuItem8 = New System.Windows.Forms.MenuItem
        Me.MenuItem9 = New System.Windows.Forms.MenuItem
        Me.MenuItem10 = New System.Windows.Forms.MenuItem
        Me.MenuItem11 = New System.Windows.Forms.MenuItem
        Me.MenuItem12 = New System.Windows.Forms.MenuItem
        Me.MenuItem13 = New System.Windows.Forms.MenuItem
        Me.MenuItem2 = New System.Windows.Forms.MenuItem
        Me.MenuItem14 = New System.Windows.Forms.MenuItem
        Me.MenuItem15 = New System.Windows.Forms.MenuItem
        Me.MenuItem17 = New System.Windows.Forms.MenuItem
        Me.MenuItem18 = New System.Windows.Forms.MenuItem
        '
        'txtTerm
        '
        Me.txtTerm.Location = New System.Drawing.Point(1, 0)
        Me.txtTerm.MaxLength = 65536
        Me.txtTerm.Multiline = True
        Me.txtTerm.ScrollBars = System.Windows.Forms.ScrollBars.Both
        Me.txtTerm.Size = New System.Drawing.Size(240, 163)
        Me.txtTerm.Text = ""
        '
        'MenuItem16
        '
        Me.MenuItem16.Text = "4800 bps"
        '
        'chkDTR
        '
        Me.chkDTR.Checked = True
        Me.chkDTR.CheckState = System.Windows.Forms.CheckState.Checked
        Me.chkDTR.Location = New System.Drawing.Point(168, 224)
        Me.chkDTR.Size = New System.Drawing.Size(48, 16)
        Me.chkDTR.Text = "DTR"
        '
        'chkRTS
        '
        Me.chkRTS.Checked = True
        Me.chkRTS.CheckState = System.Windows.Forms.CheckState.Checked
        Me.chkRTS.Location = New System.Drawing.Point(168, 240)
        Me.chkRTS.Size = New System.Drawing.Size(48, 20)
        Me.chkRTS.Text = "RTS"
        '
        'chkEnableOnComm
        '
        Me.chkEnableOnComm.Checked = True
        Me.chkEnableOnComm.CheckState = System.Windows.Forms.CheckState.Checked
        Me.chkEnableOnComm.Location = New System.Drawing.Point(0, 240)
        Me.chkEnableOnComm.Size = New System.Drawing.Size(72, 20)
        Me.chkEnableOnComm.Text = "OnComm"
        '
        'Button1
        '
        Me.Button1.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular)
        Me.Button1.Location = New System.Drawing.Point(2, 192)
        Me.Button1.Size = New System.Drawing.Size(80, 19)
        Me.Button1.Text = "Poll Receive"
        '
        'Button2
        '
        Me.Button2.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular)
        Me.Button2.Location = New System.Drawing.Point(2, 168)
        Me.Button2.Size = New System.Drawing.Size(80, 19)
        Me.Button2.Text = "Display HW"
        '
        'txtHW
        '
        Me.txtHW.Location = New System.Drawing.Point(88, 168)
        Me.txtHW.Size = New System.Drawing.Size(78, 22)
        Me.txtHW.Text = ""
        '
        'Button3
        '
        Me.Button3.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular)
        Me.Button3.Location = New System.Drawing.Point(2, 216)
        Me.Button3.Size = New System.Drawing.Size(80, 21)
        Me.Button3.Text = "Wait For"
        '
        'Button4
        '
        Me.Button4.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular)
        Me.Button4.Location = New System.Drawing.Point(88, 192)
        Me.Button4.Size = New System.Drawing.Size(76, 20)
        Me.Button4.Text = "Send Bin"
        '
        'Button5
        '
        Me.Button5.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular)
        Me.Button5.Location = New System.Drawing.Point(168, 168)
        Me.Button5.Size = New System.Drawing.Size(49, 21)
        Me.Button5.Text = "Other"
        '
        'TextBox1
        '
        Me.TextBox1.Location = New System.Drawing.Point(168, 192)
        Me.TextBox1.Size = New System.Drawing.Size(50, 22)
        Me.TextBox1.Text = ""
        '
        'Button6
        '
        Me.Button6.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular)
        Me.Button6.Location = New System.Drawing.Point(88, 216)
        Me.Button6.Size = New System.Drawing.Size(76, 22)
        Me.Button6.Text = "Send Wait CTS"
        '
        'Button7
        '
        Me.Button7.Font = New System.Drawing.Font("Microsoft Sans Serif", 8.25!, System.Drawing.FontStyle.Regular)
        Me.Button7.Location = New System.Drawing.Point(88, 241)
        Me.Button7.Size = New System.Drawing.Size(76, 22)
        Me.Button7.Text = "Clear Term"
        '
        'SaveFileDialog1
        '
        Me.SaveFileDialog1.FileName = "doc1"
        '
        'MainMenu2
        '
        Me.MainMenu2.MenuItems.Add(Me.MenuItem1)
        Me.MainMenu2.MenuItems.Add(Me.MenuItem17)
        Me.MainMenu2.MenuItems.Add(Me.MenuItem18)
        '
        'MenuItem1
        '
        Me.MenuItem1.MenuItems.Add(Me.MenuItem3)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem4)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem5)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem6)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem7)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem8)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem9)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem10)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem11)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem12)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem13)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem2)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem14)
        Me.MenuItem1.MenuItems.Add(Me.MenuItem15)
        Me.MenuItem1.Text = "Port"
        '
        'MenuItem3
        '
        Me.MenuItem3.Text = "Com1:"
        '
        'MenuItem4
        '
        Me.MenuItem4.Text = "Com2:"
        '
        'MenuItem5
        '
        Me.MenuItem5.Text = "Com3:"
        '
        'MenuItem6
        '
        Me.MenuItem6.Text = "Com4:"
        '
        'MenuItem7
        '
        Me.MenuItem7.Text = "Com5:"
        '
        'MenuItem8
        '
        Me.MenuItem8.Text = "Com6:"
        '
        'MenuItem9
        '
        Me.MenuItem9.Text = "Com7:"
        '
        'MenuItem10
        '
        Me.MenuItem10.Text = "Com8:"
        '
        'MenuItem11
        '
        Me.MenuItem11.Text = "-"
        '
        'MenuItem12
        '
        Me.MenuItem12.Text = "300 bps"
        '
        'MenuItem13
        '
        Me.MenuItem13.Text = "1200 bps"
        '
        'MenuItem2
        '
        Me.MenuItem2.Text = "4800 bps"
        '
        'MenuItem14
        '
        Me.MenuItem14.Text = "9600 bps"
        '
        'MenuItem15
        '
        Me.MenuItem15.Text = "115200 bps"
        '
        'MenuItem17
        '
        Me.MenuItem17.Text = "Open Port"
        '
        'MenuItem18
        '
        Me.MenuItem18.Text = "Log to File"
        '
        'CFNETTerm
        '
        Me.ClientSize = New System.Drawing.Size(244, 266)
        Me.Controls.Add(Me.Button7)
        Me.Controls.Add(Me.Button6)
        Me.Controls.Add(Me.TextBox1)
        Me.Controls.Add(Me.Button5)
        Me.Controls.Add(Me.Button4)
        Me.Controls.Add(Me.Button3)
        Me.Controls.Add(Me.txtHW)
        Me.Controls.Add(Me.Button2)
        Me.Controls.Add(Me.Button1)
        Me.Controls.Add(Me.chkEnableOnComm)
        Me.Controls.Add(Me.chkRTS)
        Me.Controls.Add(Me.chkDTR)
        Me.Controls.Add(Me.txtTerm)
        Me.MaximizeBox = False
        Me.Menu = Me.MainMenu2
        Me.MinimizeBox = False
        Me.Text = "CFNETTerm"

    End Sub

#End Region

    Public WithEvents SerialPort As New SerialIO.SerialPort
    Public WithEvents OtherSerial As New SerialIO.SerialPort

    Private ScreenBuffer As String
    Private ScreenBuff As New StringBuilder(15000)
    Private LogfileName As String
    Private LogToFile As Boolean
    Private fs As System.IO.FileStream
    Private myWriter As System.IO.StreamWriter
    Dim CurrentTime As DateTime
    Private ErrorMessage As String = ""

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        With SerialPort
            .EnableOnComm = True
            .CTSHandshaking = True
            .StopBits = 1
            .DataBits = 8
            .Parity = "N"
            .BitRate = 115200
            .MaxInputLen = 32768
            .XonXoffHandshaking = False
            Try
                .CommPort = 4
            Catch ex As Exception
                MsgBox(ex.Message)
            End Try
        End With
        MenuItem6.Checked = True
        MenuItem15.Checked = True
        txtTerm.Focus()
    End Sub

    Private Sub ReceiveEvent() Handles SerialPort.OnComm
        If LogToFile = True Then
            Dim Buffer As String = SerialPort.InputString
            myWriter.Write(Buffer)
        Else
            ScreenBuff.Append(SerialPort.InputString)
            'This is FAR from the best way to display (or manage) this data.  It is "quick and dirty."
            Me.Invoke(New EventHandler(AddressOf DisplayData))
        End If
    End Sub

    Private Sub DisplayData(ByVal sender As Object, ByVal e As EventArgs)
        'This marshalls receive data from the receive thread context (OnComm or CommError) to the Windows Form STAThread context
        With txtTerm
            .Text = ScreenBuff.ToString
            .SelectionStart = .Text.Length
            If (ErrorMessage.Length > 0) Then
                .SelectedText = ErrorMessage
                ErrorMessage = ""
            End If
        End With
        With ScreenBuff
            If .Length > 0.8 * .Capacity Then
                ScreenBuff.Remove(0, CInt(0.6 * .Capacity))
            End If
        End With
    End Sub

    Private Sub CFNETTerm_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        Try
            SerialPort.PortOpen = False    'this is vital!!!  It terminates the read-thread properly
            SerialPort = Nothing
        Catch ex As Exception
        Finally
        End Try
        Try
            OtherSerial.PortOpen = False    'this is vital!!!  It terminates the read-thread properly
            OtherSerial = Nothing
        Catch ex As Exception
        Finally
        End Try
    End Sub

    Private Sub txtTerm_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles txtTerm.KeyPress
        With SerialPort
            If .PortOpen = True Then
                .Output(e.KeyChar.ToString)
            End If
            e.Handled = True
        End With
    End Sub

    Private Sub ClearPortChecks()
        MenuItem3.Checked = False
        MenuItem4.Checked = False
        MenuItem5.Checked = False
        MenuItem6.Checked = False
        MenuItem7.Checked = False
        MenuItem8.Checked = False
        MenuItem9.Checked = False
        MenuItem10.Checked = False
    End Sub

    Private Sub MenuItem3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem3.Click
        If OpenPort(1) = True Then
            ClearPortChecks()
            MenuItem3.Checked = True
        End If
    End Sub

    Private Sub MenuItem4_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem4.Click
        If OpenPort(2) = True Then
            ClearPortChecks()
            MenuItem4.Checked = True
        End If
    End Sub

    Private Sub MenuItem5_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem5.Click
        If OpenPort(3) = True Then
            ClearPortChecks()
            MenuItem5.Checked = True
        End If
    End Sub

    Private Sub MenuItem6_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem6.Click
        If OpenPort(4) = True Then
            ClearPortChecks()
            MenuItem6.Checked = True
        End If
    End Sub

    Private Sub MenuItem7_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem7.Click
        If OpenPort(5) = True Then
            ClearPortChecks()
            MenuItem7.Checked = True
        End If
    End Sub

    Private Sub MenuItem8_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem8.Click
        If OpenPort(5) = True Then
            ClearPortChecks()
            MenuItem8.Checked = True
        End If
    End Sub

    Private Sub MenuItem9_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem9.Click
        If OpenPort(6) = True Then
            ClearPortChecks()
            MenuItem9.Checked = True
        End If
    End Sub

    Private Sub MenuItem10_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem10.Click
        If OpenPort(8) = True Then
            ClearPortChecks()
            MenuItem10.Checked = True
        End If
    End Sub

    Private Sub ClearBitRateChecks()
        MenuItem12.Checked = False
        MenuItem13.Checked = False
        MenuItem14.Checked = False
        MenuItem15.Checked = False
        MenuItem16.Checked = False
    End Sub

    Private Sub MenuItem12_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem12.Click
        SerialPort.BitRate = 300
        ClearBitRateChecks()
        MenuItem12.Checked = True
    End Sub

    Private Sub MenuItem13_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem13.Click
        SerialPort.BitRate = 1200
        ClearBitRateChecks()
        MenuItem13.Checked = True
    End Sub

    Private Sub MenuItem14_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem14.Click
        SerialPort.BitRate = 9600
        ClearBitRateChecks()
        MenuItem14.Checked = True
    End Sub

    Private Sub MenuItem15_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem15.Click
        SerialPort.BitRate = 115200
        ClearBitRateChecks()
        MenuItem15.Checked = True
    End Sub

    Private Sub chkDTR_CheckStateChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkDTR.CheckStateChanged
        SerialPort.DTREnable = chkDTR.Checked
    End Sub

    Private Sub chkRTS_CheckStateChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles chkRTS.CheckStateChanged
        SerialPort.RTSEnable = chkRTS.Checked
    End Sub

    Private Sub chkEnableOnComm_CheckStateChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkEnableOnComm.CheckStateChanged
        SerialPort.EnableOnComm = chkEnableOnComm.Checked
    End Sub

    Private Function OpenPort(ByVal Port As Integer) As Boolean
        Try
            SerialPort.CommPort = Port
            Return True
        Catch ex As Exception
        End Try
    End Function

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        Dim Buffer() As Byte
        Dim I As Integer
        If chkEnableOnComm.Checked = True Then
            chkEnableOnComm.Checked = False
            SerialPort.EnableOnComm = False
        End If
        txtTerm.Text = ""
        With SerialPort
            If .InBufferCount > 0 Then
                Buffer = .InputArray
                If Not (Buffer Is Nothing) Then
                    ScreenBuffer = ""
                    For I = 0 To Buffer.GetUpperBound(0)
                        ScreenBuffer += Hex(Buffer(I)).PadLeft(2) & " "
                    Next
                    'Marshalling is not required here
                    txtTerm.Text = ScreenBuffer
                    txtTerm.SelectionStart = txtTerm.Text.Length
                End If
            End If
        End With
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        Static State As Integer
        State += 1
        If State >= 5 Then State = 1
        With SerialPort
            Select Case State
                Case 1
                    'display CD
                    txtHW.Text = "CD = " & CStr(.CD)
                Case 2
                    txtHW.Text = "CTS = " & CStr(.CTS)
                Case 3
                    txtHW.Text = "DSR = " & CStr(.DSR)
                Case 4
                    txtHW.Text = "RI = " & CStr(.RI)
            End Select
        End With
    End Sub

    Private Function WaitForResult() As String    'for example
        Dim Finished As Boolean
        Dim Result As New StringBuilder(2048)
        With SerialPort
            If chkEnableOnComm.Checked = True Then
                chkEnableOnComm.Checked = False
                .EnableOnComm = False
            End If
            Do Until Finished = True OrElse .PortOpen = False
                Try
                    If .InBufferCount > 0 Then
                        Result.Append(.InputString)
                        If Result.ToString.EndsWith(vbCr) Then
                            Finished = True
                            Return Result.ToString
                        End If
                    Else
                        System.Windows.Forms.Application.DoEvents()
                        Thread.Sleep(1)
                    End If
                Catch ex As Exception  'there will be an exception, if the form is closed while this loop is executing
                End Try
            Loop
        End With
    End Function

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        Try
            txtTerm.Text = WaitForResult()
        Catch ex As Exception
        End Try
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        Dim Buffer(255) As Byte
        For I As Byte = 0 To 255
            Buffer(I) = I
        Next
        SerialPort.Output(Buffer)
    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        Dim Buffer As String
        With OtherSerial
            .CommPort = 1
            .BitRate = 115200
            .EnableOnComm = True
            If .PortOpen = False Then .PortOpen = True
            .Output("This is a test")
        End With
    End Sub

    Private Sub OtherSerial_OnComm() Handles OtherSerial.OnComm
        Dim Buffer As String
        Buffer = OtherSerial.InputString
        TextBox1.Text = Buffer
    End Sub

    Private Sub MenuItem16_Click(ByVal sender As Object, ByVal e As System.EventArgs) Handles MenuItem16.Click
        SerialPort.BitRate = 4800
        ClearBitRateChecks()
        MenuItem16.Checked = True
    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        Dim Data2Send As String = "1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz - Now is the time for all good men to come to the aid of the party.  The quick brown fox jumped over the lazy dog.  Then some more test stuff.  "
        Dim DataArray2Send() As Char = Data2Send.ToCharArray
        With SerialPort
            .CTSHandshaking = False    'just to test this code
            For I As Integer = 0 To DataArray2Send.Length - 1
                If .CTS = True Then
                    .Output(DataArray2Send(I))
                Else
                    Do Until .CTS = True
                        Thread.Sleep(1)
                    Loop
                End If
            Next
            .CTSHandshaking = True
        End With
    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click
        txtTerm.Text = ""
        ScreenBuff.Remove(0, ScreenBuff.Length)
    End Sub

    Private Sub Button8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs)
        txtTerm.Text = ScreenBuff.ToString     'the maximum data that may be displayed is 64K
        Dim Display As String = ScreenBuff.ToString
    End Sub

    Private Sub MenuItem18_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem18.Click
        If SerialPort.PortOpen = True Then
            If MenuItem18.Text = "Log to File" Then
                MenuItem18.Text = "Stop Logging"
                With SaveFileDialog1
                    .FileName = LogfileName
                    .ShowDialog()
                    If .FileName <> "" Then
                        LogfileName = .FileName
                        MsgBox("Logging will start when this dialog is closed. Receive data will NOT be displayed. Click again to stop logging.", MsgBoxStyle.Information)
                        fs = New System.IO.FileStream(LogfileName, System.IO.FileMode.CreateNew)
                        myWriter = New System.IO.StreamWriter(fs)
                        SerialPort.EnableOnComm = True
                        chkEnableOnComm.Checked = True
                        LogToFile = True
                    Else
                        With MenuItem18
                            .Enabled = True
                            .Text = "Log to File"
                        End With
                    End If
                End With
            Else
                With MenuItem18
                    .Enabled = True
                    .Text = "Log to File"
                End With
                Try
                    myWriter.Flush()
                    fs.Flush()
                    fs.Close()
                Catch ex As Exception
                End Try
            End If
        Else
            MsgBox("Port must be open before logging.", MsgBoxStyle.Exclamation)
        End If
    End Sub

    Private Sub MenuItem17_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem17.Click
        With SerialPort
            If MenuItem17.Text = "Open Port" Then
                .PortOpen = True
                If .PortOpen = True Then MenuItem17.Text = "Close Port"
            Else
                .PortOpen = False
                If .PortOpen = False Then MenuItem17.Text = "Open Port"
            End If
        End With
    End Sub

    Private Sub SerialPort_CommError(ByVal ErrorFlag As CFSerialClass.SerialIO.SerialPort.CommErrorFlags) Handles SerialPort.CommError
        'Display the error message
        ErrorMessage = vbCrLf & "Communications Error: " & ErrorFlag.ToString & vbCrLf
        Me.Invoke(New EventHandler(AddressOf DisplayData))
    End Sub
End Class

