using System;
using System.Drawing;
using System.Collections;
using System.Windows.Forms;
using System.Data;
using CFSerialClass.SerialIO;

namespace CSharpExample
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TextBox txtTerm;
		private System.Windows.Forms.MainMenu mainMenu1;
		private CFSerialClass.SerialIO.SerialPort SerialPort;

		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			base.Dispose( disposing );
		}
		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.txtTerm = new System.Windows.Forms.TextBox();
			// 
			// txtTerm
			// 
			this.txtTerm.Multiline = true;
			this.txtTerm.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtTerm.Size = new System.Drawing.Size(232, 208);
			this.txtTerm.Text = "";
			// 
			// Form1
			// 
			this.Controls.Add(this.txtTerm);
			this.MaximizeBox = false;
			this.Menu = this.mainMenu1;
			this.MinimizeBox = false;
			this.Text = "Form1";
			this.Load += new System.EventHandler(this.Form1_Load);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>

		static void Main() 
		{
			Application.Run(new Form1());
		}

		private void Form1_Load(object sender, System.EventArgs e)
		{
			SerialPort = new SerialPort();
			SerialPort.CommPort = 4;
			SerialPort.BitRate =  9600;
			SerialPort.DataBits = 8;
			SerialPort.RTSEnable = true;
			SerialPort.DTREnable = true;
			SerialPort.StopBits = 1;
			SerialPort.EnableOnComm = true;
			SerialPort.PortOpen = true;
			// define an event handler
			SerialPort.OnComm +=new SerialPort.OnCommEventHandler(DataReceived);
			// you will want to actually send data from something like the txtTerm KeyPress event
			string Buffer = "This is a test";
			SerialPort.Output(Buffer);
		}
		private void Form1_Closing(object sender, System.EventArgs e)
		{
			if (SerialPort.PortOpen == true) SerialPort.PortOpen = false;
		}
		private void DataReceived()
		{
			string inputData;

			// read input text
			// you may want to use StringBuilder instead of string
			inputData = SerialPort.InputString();

			// display it
			txtTerm.Text += inputData;
		}
	}
}
